<?LassoScript

if(!Lasso_TagExists('xs_inc'));
	define_tag('inc',
		-namespace = 'xs_',
		-description = '
			Defines a replacement from standard include tag.
			Determines if the file requested exists:
				if it does then the functionality is identical to "include"
				if not, it will test for the existance of the core version 
					and include that if exists.
			Requires that either $xsgv_core is set, or pass -core as the SECOND param
			xsgv == xServe Global Variable!
			');
	!var_defined('gv_error') ? var('gv_error' = string);
	
	inline(var('gv_sql'),Action_Params);	
		local(
			'includeme' = null,
			'corevar' = null,
			'req' = null
			);
			
		if(params->size == 0);
			/* GRACEFULLY degrade */
			return('');
			
		else(params->size == 1);
			/*
				assume file requested is the only param passed 
				just like std include
			*/
			local('req' = string(params->get(1)));
			if(var_defined('xsgv_core'));
				/*
					set corevar = top level core
				*/
					#corevar = $xsgv_core;
			else;
				/*
					standard file included because no core has been defined.
					no vars need to be set here due to graceful degrade below
				*/
			/if;
			
			
		else(params->size == 2 && local_defined('core'));
			/*
				User defined core has been requested
			*/
			local('req' = string(params->get(1)));
			#corevar = #core;
		/if;
	
	
		/* test for local exists, if not, use core */
		if(file_exists(#req));
			/* LOCAL exists so use it */
			#includeme = #req;
		else;
			/* use CORE */
			#corevar->removetrailing('/');
			!(#req->beginswith('/')) ? #req = Response_Path + #req;
			#req->removeLeading('/');
			#includeme = #corevar'/'#req;
			
		//	return(#includeme);
		/if;
	
		/* 
			include file contents. protect makes sure it silently degrades 
			if you wish to report errors from your inlude you MUST use vars
		*/
		//	#includeme->replace('//','/');

		protect;
			return(process(file_read(#includeme)));
			handle;
				xs_iserror;
			/handle;
		/protect;
	/inline;
	/define_tag;
/if;

if(!Lasso_TagExists('xs_incCore'));
	define_tag('incCore',
		-namespace = 'xs_',
		-description = '
			Similar to xs_inc but force-uses the core
			');
		inline(var('gv_sql'),Action_Params);	
			local(
				'includeme' = null,
				'corevar' = null,
				'req' = null
				);
				
			if(params->size == 0);
				/* GRACEFULLY degrade */
				return('');
				
			else(params->size == 1);
				/*
					assume file requested is the only param passed 
					just like std include
				*/
				local('req' = string(params->get(1)));
				if(var_defined('xsgv_core'));
					/*
						set corevar = top level core
					*/
						#corevar = $xsgv_core;
				else;
					/*
						standard file included because no core has been defined.
						no vars need to be set here due to graceful degrade below
					*/
				/if;
				
				
			else(params->size == 2 && local_defined('core'));
				/*
					User defined core has been requested
				*/
				local('req' = string(params->get(1)));
				#corevar = #core;
			/if;
		
		
	
				/* use CORE */
				#corevar->removetrailing('/');
				!(#req->beginswith('/')) ? #req = Response_Path + #req;
				#req->removeLeading('/');
				#includeme = #corevar'/'#req;
	
			protect;
				return(process(file_read(#includeme)));
				handle;
					xs_iserror;
				/handle;
			/protect;
		/inline;
	/define_tag;
/if;
?>